<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_accordion_' . $id . '_settings', $settings);

$output = '<div class="labb-accordion labb-' . $settings->style
    . '" data-toggle="' . ($settings->toggle == 'yes' ? "true" : "false")
    . '" data-expanded="' . ($settings->expanded == 'yes' ? "true" : "false") . '">';

foreach ($settings->accordion as $panel) :

    if (!is_object($panel))
        continue;

    if (empty($panel->panel_id))
        $panel_id = sanitize_title_with_dashes($panel->panel_title);
    else
        $panel_id = $panel->panel_id;

    $child_output = '<div class="labb-panel" id="' . $panel_id . '">';

    $child_output .= '<div class="labb-panel-title">' . esc_html($panel->panel_title) . '</div>';

    $child_output .= '<div class="labb-panel-content">' . do_shortcode($panel->panel_content) . '</div>';

    $child_output .= '</div><!-- .labb-panel -->';

    $output .= apply_filters('labb_accordion_item_output', $child_output, $panel, $settings);

endforeach;

$output .= '</div><!-- .labb-accordion -->';

echo apply_filters('labb_accordion_output', $output, $settings);